<?php //d2e7017d6318ff512c6153aa3268eff4
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Collection;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Activation_C;
    use LaravelIdea\Helper\App\Models\_IH_Activation_QB;
    use LaravelIdea\Helper\App\Models\_IH_ApiKey_C;
    use LaravelIdea\Helper\App\Models\_IH_ApiKey_QB;
    use LaravelIdea\Helper\App\Models\_IH_DashboardWidget_C;
    use LaravelIdea\Helper\App\Models\_IH_DashboardWidget_QB;
    use LaravelIdea\Helper\App\Models\_IH_Downloadable_C;
    use LaravelIdea\Helper\App\Models\_IH_Downloadable_QB;
    use LaravelIdea\Helper\App\Models\_IH_DownloadLog_C;
    use LaravelIdea\Helper\App\Models\_IH_DownloadLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_Generator_C;
    use LaravelIdea\Helper\App\Models\_IH_Generator_QB;
    use LaravelIdea\Helper\App\Models\_IH_LicenseKey_C;
    use LaravelIdea\Helper\App\Models\_IH_LicenseKey_QB;
    use LaravelIdea\Helper\App\Models\_IH_Log_C;
    use LaravelIdea\Helper\App\Models\_IH_Log_QB;
    use LaravelIdea\Helper\App\Models\_IH_Meta_C;
    use LaravelIdea\Helper\App\Models\_IH_Meta_QB;
    use LaravelIdea\Helper\App\Models\_IH_Product_C;
    use LaravelIdea\Helper\App\Models\_IH_Product_QB;
    use LaravelIdea\Helper\App\Models\_IH_Setting_C;
    use LaravelIdea\Helper\App\Models\_IH_Setting_QB;
    use LaravelIdea\Helper\App\Models\_IH_Telemetry_C;
    use LaravelIdea\Helper\App\Models\_IH_Telemetry_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    
    /**
     * @property int $id
     * @property int $license_key_id
     * @property string|null $ip_address
     * @property string|null $identifier
     * @property string|null $post_url
     * @property Carbon $activation_date
     * @property int $activation_counter
     * @property int $deactivation_counter
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LicenseKey $licenseKey
     * @method BelongsTo|_IH_LicenseKey_QB licenseKey()
     * @method static _IH_Activation_QB onWriteConnection()
     * @method _IH_Activation_QB newQuery()
     * @method static _IH_Activation_QB on(null|string $connection = null)
     * @method static _IH_Activation_QB query()
     * @method static _IH_Activation_QB with(array|string $relations)
     * @method _IH_Activation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Activation_C|Activation[] all()
     * @ownLinks license_key_id,\App\Models\LicenseKey,id
     * @mixin _IH_Activation_QB
     */
    class Activation extends Model {}
    
    /**
     * @property int $id
     * @property string $api_key
     * @property string $description
     * @property string $ip_address
     * @property bool $is_active
     * @property bool $can_verify
     * @property bool $can_activate
     * @property bool $can_deactivate
     * @property bool $can_get_license_key_details
     * @property bool $can_access_downloadables
     * @property bool $can_assign_license_key
     * @property bool $can_create_license_key
     * @property bool $can_create_product
     * @property bool $can_create_product_meta
     * @property bool $can_create_license_key_meta
     * @property bool $can_update_license_key
     * @property bool $can_update_product
     * @property bool $can_update_product_meta
     * @property bool $can_update_license_key_meta
     * @property bool $can_delete_license_key
     * @property bool $can_delete_product
     * @property bool $can_delete_product_meta
     * @property bool $can_delete_license_key_meta
     * @property bool $can_get_all_products
     * @property bool $can_get_license_keys
     * @property bool $can_get_all_generators
     * @property bool $can_generate
     * @property bool $can_send_telemetry_data
     * @property bool $can_get_telemetry_data
     * @property bool $can_assign_and_activate_license_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $can_get_available_license_keys_count
     * @method static _IH_ApiKey_QB onWriteConnection()
     * @method _IH_ApiKey_QB newQuery()
     * @method static _IH_ApiKey_QB on(null|string $connection = null)
     * @method static _IH_ApiKey_QB query()
     * @method static _IH_ApiKey_QB with(array|string $relations)
     * @method _IH_ApiKey_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ApiKey_C|ApiKey[] all()
     * @mixin _IH_ApiKey_QB
     */
    class ApiKey extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $product_id
     * @property string $data_group
     * @property string $chart_type
     * @property string $x_axis
     * @property string $y_axis
     * @property bool $is_correct_format
     * @property bool $license_key_exists
     * @property bool $product_exists
     * @property bool $product_version_exists
     * @property string $conjunction_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DashboardWidget_QB onWriteConnection()
     * @method _IH_DashboardWidget_QB newQuery()
     * @method static _IH_DashboardWidget_QB on(null|string $connection = null)
     * @method static _IH_DashboardWidget_QB query()
     * @method static _IH_DashboardWidget_QB with(array|string $relations)
     * @method _IH_DashboardWidget_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DashboardWidget_C|DashboardWidget[] all()
     * @ownLinks product_id,\App\Models\Product,id
     * @mixin _IH_DashboardWidget_QB
     */
    class DashboardWidget extends Model {}
    
    /**
     * @property int $id
     * @property int $downloadable_id
     * @property string $ip_address
     * @property string $user_agent
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DownloadLog_QB onWriteConnection()
     * @method _IH_DownloadLog_QB newQuery()
     * @method static _IH_DownloadLog_QB on(null|string $connection = null)
     * @method static _IH_DownloadLog_QB query()
     * @method static _IH_DownloadLog_QB with(array|string $relations)
     * @method _IH_DownloadLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DownloadLog_C|DownloadLog[] all()
     * @ownLinks downloadable_id,\App\Models\Downloadable,id
     * @mixin _IH_DownloadLog_QB
     */
    class DownloadLog extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property int $numeric_version
     * @property string $version
     * @property string $update_summary
     * @property string $changelog
     * @property bool $published
     * @property Carbon $release_date
     * @property Carbon|null $assigned_after
     * @property Carbon|null $assigned_before
     * @property Carbon|null $expires_before
     * @property Carbon|null $accessible_until
     * @property int $download_counter
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_Downloadable_QB onWriteConnection()
     * @method _IH_Downloadable_QB newQuery()
     * @method static _IH_Downloadable_QB on(null|string $connection = null)
     * @method static _IH_Downloadable_QB query()
     * @method static _IH_Downloadable_QB with(array|string $relations)
     * @method _IH_Downloadable_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Downloadable_C|Downloadable[] all()
     * @ownLinks product_id,\App\Models\Product,id
     * @foreignLinks id,\App\Models\DownloadLog,downloadable_id
     * @mixin _IH_Downloadable_QB
     */
    class Downloadable extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property string $method
     * @property string|null $prefix
     * @property string|null $suffix
     * @property string|null $function_name
     * @property int $number_of_chunks
     * @property int $chunk_length
     * @property int $activation_limit
     * @property int $validity
     * @property bool $status
     * @property string $charset
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_Generator_QB onWriteConnection()
     * @method _IH_Generator_QB newQuery()
     * @method static _IH_Generator_QB on(null|string $connection = null)
     * @method static _IH_Generator_QB query()
     * @method static _IH_Generator_QB with(array|string $relations)
     * @method _IH_Generator_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Generator_C|Generator[] all()
     * @ownLinks product_id,\App\Models\Product,id
     * @mixin _IH_Generator_QB
     */
    class Generator extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property string $license_key
     * @property string|null $owner_name
     * @property string|null $owner_email
     * @property int $activation_limit
     * @property int $validity
     * @property Carbon|null $assigned_at
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read Collection $meta_data attribute
     * @property _IH_Meta_C|Meta[] $getMetaDataAttribute
     * @property-read int $get_meta_data_attribute_count
     * @method HasMany|_IH_Meta_QB getMetaDataAttribute()
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_LicenseKey_QB onWriteConnection()
     * @method _IH_LicenseKey_QB newQuery()
     * @method static _IH_LicenseKey_QB on(null|string $connection = null)
     * @method static _IH_LicenseKey_QB query()
     * @method static _IH_LicenseKey_QB with(array|string $relations)
     * @method _IH_LicenseKey_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LicenseKey_C|LicenseKey[] all()
     * @ownLinks product_id,\App\Models\Product,id
     * @foreignLinks id,\App\Models\Activation,license_key_id
     * @mixin _IH_LicenseKey_QB
     */
    class LicenseKey extends Model {}
    
    /**
     * @property int $id
     * @property int $action
     * @property string $group
     * @property string $identifier
     * @property string $internal_description
     * @property string|null $data
     * @property string $ip_address
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Log_QB onWriteConnection()
     * @method _IH_Log_QB newQuery()
     * @method static _IH_Log_QB on(null|string $connection = null)
     * @method static _IH_Log_QB query()
     * @method static _IH_Log_QB with(array|string $relations)
     * @method _IH_Log_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Log_C|Log[] all()
     * @mixin _IH_Log_QB
     */
    class Log extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property int $item_id
     * @property string $key
     * @property string $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Meta_QB onWriteConnection()
     * @method _IH_Meta_QB newQuery()
     * @method static _IH_Meta_QB on(null|string $connection = null)
     * @method static _IH_Meta_QB query()
     * @method static _IH_Meta_QB with(array|string $relations)
     * @method _IH_Meta_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Meta_C|Meta[] all()
     * @mixin _IH_Meta_QB
     */
    class Meta extends Model {}
    
    /**
     * @property int $id
     * @property string|null $external_reference
     * @property string $source
     * @property string $name
     * @property string $post_url
     * @property string $description
     * @property string $status
     * @property bool $require_non_expired
     * @property string $algorithm
     * @property string $passphrase
     * @property string $private_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read Collection $meta_data attribute
     * @property _IH_Meta_C|Meta[] $getMetaDataAttribute
     * @property-read int $get_meta_data_attribute_count
     * @method HasMany|_IH_Meta_QB getMetaDataAttribute()
     * @method static _IH_Product_QB onWriteConnection()
     * @method _IH_Product_QB newQuery()
     * @method static _IH_Product_QB on(null|string $connection = null)
     * @method static _IH_Product_QB query()
     * @method static _IH_Product_QB with(array|string $relations)
     * @method _IH_Product_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_C|Product[] all()
     * @foreignLinks id,\App\Models\LicenseKey,product_id|id,\App\Models\Downloadable,product_id|id,\App\Models\Telemetry,product_id|id,\App\Models\Generator,product_id|id,\App\Models\DashboardWidget,product_id
     * @mixin _IH_Product_QB
     */
    class Product extends Model {}
    
    /**
     * @property int $id
     * @property string $group
     * @property string $name
     * @property string|null $value
     * @method static _IH_Setting_QB onWriteConnection()
     * @method _IH_Setting_QB newQuery()
     * @method static _IH_Setting_QB on(null|string $connection = null)
     * @method static _IH_Setting_QB query()
     * @method static _IH_Setting_QB with(array|string $relations)
     * @method _IH_Setting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Setting_C|Setting[] all()
     * @mixin _IH_Setting_QB
     */
    class Setting extends Model {}
    
    /**
     * @property int $id
     * @property string|null $user_identifier
     * @property string|null $license_key
     * @property string|null $activation_identifier
     * @property int|null $product_id
     * @property string|null $product_version
     * @property string $data_type
     * @property string $data_group
     * @property string $data
     * @property bool $is_correct_format
     * @property bool $license_key_exists
     * @property bool $product_exists
     * @property bool $product_version_exists
     * @property bool $has_red_flags
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product|null $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_Telemetry_QB onWriteConnection()
     * @method _IH_Telemetry_QB newQuery()
     * @method static _IH_Telemetry_QB on(null|string $connection = null)
     * @method static _IH_Telemetry_QB query()
     * @method static _IH_Telemetry_QB with(array|string $relations)
     * @method _IH_Telemetry_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Telemetry_C|Telemetry[] all()
     * @ownLinks product_id,\App\Models\Product,id
     * @mixin _IH_Telemetry_QB
     */
    class Telemetry extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string $role
     * @property bool $is_2fa_enabled
     * @property string|null $two_factor_secret
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @mixin _IH_User_QB
     * @method static UserFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class User extends Model {}
}