<div wire:ignore.self class="modal fade" id="updateItemModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="updateItemModallLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="updateItem" id="updateItemForm">
            <input type="hidden" wire:model="userId">

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{ __('Update User') }}</h5>
                </div>
                <div class="modal-body" x-data="{ requireTwoFactor: @entangle('requireTwoFactor').live }">
                    <div class="mb-3">
                        <label for="user-name">{{ __('Display Name') }}</label>
                        <div class="@error('name') border border-danger rounded-3 @enderror">
                            <input id="user-name" wire:model="name" wire:change="updateItemUpdated('name')" type="text" class="form-control no-padding">
                        </div>
                        @error('name')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="user-email">{{ __('Email') }}</label>
                        <div class="@error('email') border border-danger rounded-3 @enderror">
                            <input id="user-email" wire:model="email" wire:change="updateItemUpdated('email')" type="email" class="form-control no-padding">
                        </div>
                        @error('email')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="user-password">{{ __('Change Password') }}</label>
                        <div class="@error('password') border border-danger rounded-3 @enderror">
                            <input id="user-password" wire:model="password" wire:change="updateItemUpdated('password')" type="password" class="form-control no-padding">
                        </div>
                        @error('password')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="user-confirm-password">{{ __('Confirm Password Change') }}</label>
                        <div class="@error('confirmPassword') border border-danger rounded-3 @enderror">
                            <input id="user-confirm-password" wire:model="confirmPassword" wire:change="updateItemUpdated('confirmPassword')" type="password" class="form-control no-padding">
                        </div>
                        @error('confirmPassword')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="item-status">{{ __('Require Two Factor Authentication') }}</label>
                        <div id="item-status" class="form-check form-switch ps-0">
                            <input x-model="requireTwoFactor" wire:model="requireTwoFactor" wire:change="updateItemUpdated('requireTwoFactor')" class="form-check-input ms-auto" type="checkbox" id="published" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                {{ __('Active') }}
                            </label>
                        </div>
                    </div>

                    <div x-show="requireTwoFactor">
                        <div class="mb-3">
                            <label for="user-confirm-password">{{ __('Two Factor Secret') }}</label>
                            <div class="@error('twoFactorSecret') border border-danger rounded-3 @enderror">
                                <input id="user-two-factor-secret" wire:model="twoFactorSecret" wire:input="updateItemUpdated('twoFactorSecret')" type="text" class="form-control no-padding">
                            </div>
                            @error('twoFactorSecret')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3 text-center">
                            @if($twoFactorQrCode != '')
                                <img class="img-thumbnail qr-code" src="{{ $twoFactorQrCode }}" alt="">
                            @endif
                        </div>

                        <div class="mb-3">
                            <label for="user-confirm-password">{{ __('Confirm Two Factor Code Change') }}</label>
                            <div class="@error('twoFactorCode') border border-danger rounded-3 @enderror">
                                <input id="user-two-factor-code" wire:model="twoFactorCode" wire:change="updateItemUpdated('twoFactorCode')" type="text" class="form-control no-padding">
                            </div>
                            @error('twoFactorCode')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="role" class="form-label">{{ __('Role') }}</label>
                        <select id="role" class="form-select @error('role') border border-danger rounded-3 @enderror" wire:model="role" wire:change="updateItemUpdated('role')">
                            <option value="">{{ __('Select Role') }}</option>
                            @foreach($roles as $keys => $value)
                                <option value="{{ $keys }}">{{ $value }}</option>
                            @endforeach
                        </select>

                        @error('role')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="update-item-btn" type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-update-modal', function (e) {
            $('#updateItemModal').modal('show');
        });

        window.addEventListener('close-update-modal', function (e) {
            $('#updateItemModal').modal('hide');
        });

        $('#update-item-btn').on('click', function (e) {
            e.preventDefault();

            Livewire.emit('updateItem');
        });
    </script>
@endpush
