@section('page-title')
    {{ __('Raw Telemetry Data') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('telemetry') }}">
            {{ __('Telemetry') }}
        </a>
    </li>

    <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
        {{ __('Management') }}
    </li>
@endsection

<div class="row">
    <div class="col-12">
        <div class="card mb-4 mx-4">
            <ul class="list-group list-group-flush" x-data="{ showFilterOptions: false, showBulkOptions: false }">
                <li class="list-group-item">
                    <div class="float-start">
                        <h5 class="card-title m-0">
                            @yield('page-title')
                        </h5>
                    </div>
                </li>
                <li class="list-group-item">
                    <a href="#" class="btn btn-action mb-0" x-on:click="showBulkOptions = !showBulkOptions">
                        <span x-show="!showBulkOptions" class="btn-inner--text">{{ __('Bulk Actions') }}</span>
                        <span x-show="showBulkOptions" class="btn-inner--text">{{ __('Hide Bulk Actions') }}</span>
                    </a>
                    <a href="#" class="btn btn-action mb-0" x-on:click="showFilterOptions = !showFilterOptions">
                        <span x-show="!showFilterOptions" class="btn-inner--text"><i class="fas fa-filter"></i></span>
                        <span x-show="showFilterOptions" class="btn-inner--text">{{ __('Hide Filters') }}</span>
                    </a>
                </li>

                <li class="list-group-item" x-show="showFilterOptions">
                    @include('common.filter-search')
                </li>

                <li class="list-group-item" x-show="showBulkOptions">
                    <form class="form-inline" wire:submit.prevent="bulkActions">
                        <button x-on:click="bulkDelete()" type="button" class="btn btn-action-apply btn-action-danger me-2">
                            <span class="btn-inner--text">{{ __('Delete') }}</span>
                        </button>
                    </form>
                </li>

                <li class="list-group-item p-0"></li>
            </ul>
            <div class="card-body px-0 pt-0 pb-2">
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                        <tr>
                            <th class="text-xxs opacity-7">
                                <input type="checkbox" id="bulk-action-checkbox">
                            </th>
                            <th class="ps-4 text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('License Key') }} / {{ __('Activation') }} / {{ __('User Identifier') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Product') }} / {{ __('Version') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Data') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Flags') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Created At') }}
                            </th>
                        </tr>
                        </thead>
                        <tbody>

                        @if($items->count() > 0)
                            @foreach($items as $item)
                                <tr>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">
                                            <input type="checkbox" class="bulk-action-checkbox" value="{{ $item->id }}">
                                        </p>
                                    </td>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->license_key }} / {{ $item->activation_identifier }} / {{ $item->user_identifier }}</p>
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">
                                            @if($item->product)
                                                {{ $item->product->name }}
                                            @else
                                                <span class="badge badge-sm bg-danger">{{ sprintf( __( 'Product #%d Not Found' ), $item->product_id ) }}</span>
                                            @endif / {{ $item->product_version }}</p>
                                    </td>
                                    <td class="text-start">
                                        <pre class="text-xs font-weight-bold mb-0"><span class="badge bg-success font-weight-bolder text-xs my-1 py-1 px-1">{{ __('Data Type') }}</span> = {{ $item->data_type }}</pre>
                                        <pre class="text-xs font-weight-bold mb-0"><span class="badge bg-success font-weight-bolder text-xs my-1 py-1 px-1">{{ __('Data Group') }}</span> = {{ $item->data_group }}</pre>
                                        @php($data = json_decode($item->data, true))
                                        @if($data && is_array($data))
                                            @foreach($data as $key => $value)
                                                <pre class="text-xs font-weight-bold mb-0"><span class="badge bg-success font-weight-bolder text-xs my-1 py-1 px-1">{{ $key }}</span> = {{ is_array($value) ? implode(', ', $value) : $value }}</pre>
                                            @endforeach
                                        @elseif($data && !is_array($data))
                                            <pre class="text-xs font-weight-bold mb-0"><span class="badge bg-success font-weight-bolder text-xs my-1 py-1 px-1">{{ __('Value') }}</span> = {{ $data }}</pre>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="text-start">
                                        <span class="text-xs mb-0">
                                            <span class="badge bg-success font-weight-bold text-xs my-1 py-1 px-1">{{ __('Is Correct Format') }}</span> =
                                            @if($item->is_correct_format)
                                                {{ __('Yes') }}
                                            @else
                                                <span class="badge bg-danger font-weight-bold text-xs my-1 py-1 px-1">{{ __('No') }}</span>
                                            @endif
                                        </span> <br>

                                        <span class="text-xs mb-0">
                                            <span class="badge bg-success font-weight-bold text-xs my-1 py-1 px-1">{{ __('License Key Exists') }}</span> =
                                            @if($item->license_key_exists)
                                                {{ __('Yes') }}
                                            @else
                                                <span class="badge bg-danger font-weight-bold text-xs my-1 py-1 px-1">{{ __('No') }}</span>
                                            @endif
                                        </span><br>

                                        <span class="text-xs mb-0">
                                            <span class="badge bg-success font-weight-bold text-xs my-1 py-1 px-1">{{ __('Product Exists') }}</span> =
                                            @if($item->product_exists)
                                                {{ __('Yes') }}
                                            @else
                                                <span class="badge bg-danger font-weight-bold text-xs my-1 py-1 px-1">{{ __('No') }}</span>
                                            @endif
                                        </span><br>

                                        <span class="text-xs mb-0">
                                            <span class="badge bg-success font-weight-bold text-xs my-1 py-1 px-1">{{ __('Product Version Exists') }}</span> =
                                            @if($item->product_version_exists)
                                                {{ __('Yes') }}
                                            @else
                                                <span class="badge bg-danger font-weight-bold text-xs my-1 py-1 px-1">{{ __('No') }}</span>
                                            @endif
                                        </span>
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ formatDatetime($item->created_at) }}</p>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="ps-4" colspan="8">
                                    <p class="text-center text-secondary text-xs font-weight-bold mb-0">{{ __('No telemetry found') }}</p>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>

            {{ $items->links() }}
        </div>
    </div>

    @include('common.modal-delete-item',  ['name' => 'log'])
    @include('common.confirm-bulk-action')
    @include('common.confirm-purge-action')
</div>
