@section('page-title')
    {{ __('Settings') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('settings') }}">
            {{ __('Settings') }}
        </a>
    </li>

    <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
        {{ __('Management') }}
    </li>
@endsection

<div class="container-fluid my-3 py-3">
    <div class="row mb-5">
        <div class="col-lg-3">
            <div class="card position-sticky top-1">
                <ul class="nav flex-column bg-white border-radius-lg p-3">
                    <li class="nav-item">
                        <a class="nav-link text-body" data-scroll="" href="#ui">
                            <span class="text-sm">{{ __('General') }}</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-body" data-scroll="" href="#api">
                            <span class="text-sm">{{ __('API') }}</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-body" data-scroll="" href="#envato">
                            <span class="text-sm">{{ __('Envato') }}</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-body" data-scroll="" href="#logging">
                            <span class="text-sm">{{ __('Logging') }}</span>
                        </a>
                    </li>

                    @if(!\Config::get( 'app.is_demo', false ))
                        <li class="nav-item">
                            <a class="nav-link text-body" data-scroll="" href="#keevault">
                                <span class="text-sm">{{ __('Keevault') }}</span>
                            </a>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
        <div class="col-lg-9 mt-lg-0 mt-4">
            <div class="card" id="ui">
                <form wire:submit.prevent="saveUserInterfaceSettings">
                    <div class="card-header">
                        <h5>{{ __('User Interface') }}</h5>
                    </div>
                    <div class="card-body pt-0">
                        <div class="mb-3">
                            <label for="product-ui-brand">{{ __('Brand') }}</label>
                            <div class="@error('settings.ui.brand') border border-danger rounded-3 @enderror">
                                <input id="product-ui-brand" wire:model="settings.ui.brand" wire:change="userInterfaceOptionUpdated('settings.ui.brand')" type="text" class="form-control no-padding">
                            </div>
                            @error('settings.ui.brand')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="product-ui-items">{{ __('Default Dashboard Days Per Graph') }}</label>
                            <div class="@error('settings.ui.daysPerGraph') border border-danger rounded-3 @enderror">
                                <select id="product-ui-daysPerGraph"
                                        wire:model="settings.ui.daysPerGraph"
                                        wire:change="userInterfaceOptionUpdated('settings.ui.daysPerGraph')"
                                        class="form-select no-padding">

                                    <option value="7">7</option>
                                    <option value="15">15</option>
                                    <option value="30">30</option>
                                </select>
                            </div>
                            @error('settings.ui.daysPerGraph')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="product-ui-items">{{ __('Number of items per table') }}</label>
                            <div class="@error('settings.ui.itemsPerTable') border border-danger rounded-3 @enderror">
                                <input id="product-ui-items" wire:model="settings.ui.itemsPerTable" wire:change="userInterfaceOptionUpdated('settings.ui.itemsPerTable')" type="number" class="form-control no-padding">
                            </div>
                            @error('settings.ui.itemsPerTable')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="product-ui-date-format">{{ __('Date Format') }}</label>
                            <div class="@error('settings.ui.dateFormat') border border-danger rounded-3 @enderror">
                                <input id="product-ui-date-format" wire:model="settings.ui.dateFormat" wire:change="userInterfaceOptionUpdated('settings.ui.dateFormat')" type="text" class="form-control no-padding">
                            </div>
                            @error('settings.ui.dateFormat')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="product-ui-date-format">{{ __('Time Format') }}</label>
                            <div class="@error('settings.ui.timeFormat') border border-danger rounded-3 @enderror">
                                <input id="product-ui-date-format" wire:model="settings.ui.timeFormat" wire:change="userInterfaceOptionUpdated('settings.ui.timeFormat')" type="text" class="form-control no-padding">
                            </div>
                            @error('settings.ui.timeFormat')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                        <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-3 mb-3">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>

            <div class="card mt-3" id="api">
                <form wire:submit.prevent="saveApiSettings">
                    <div class="card-header">
                        <h5>{{ __('API') }}</h5>
                    </div>
                    <div class="card-body pt-0">
                        <div class="mb-3">
                            <label for="product-ui-items">{{ __('API Response Authentication Method') }}</label>
                            <div class="@error('settings.api.authenticationMethod') border border-danger rounded-3 @enderror">
                                <select id="settings-api-authenticationMethod"
                                        wire:model="settings.api.authenticationMethod"
                                        wire:change="apiOptionUpdated('settings.api.authenticationMethod')"
                                        class="form-select no-padding">

                                    <option value="sign">{{ __('Sign') }}</option>
                                    <option value="encrypt">{{ __('Encrypt') }}</option>
                                </select>
                            </div>
                            @error('settings.ui.daysPerGraph')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>


                        <div class="mb-3">
                            <label for="settings-api-passphrase">{{ __('Passphrase') }}</label>
                            <div class="@error('settings.api.passphrase') border border-danger rounded-3 @enderror">
                                <input id="settings-api-passphrase" wire:model="settings.api.passphrase" wire:change="apiOptionUpdated('settings.api.passphrase')" type="text" class="form-control no-padding">
                            </div>
                            @error('settings.api.passphrase')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="settings-api-private">{{ __('Private Key') }}</label>
                            <div class="@error('settings.api.privateKey') border border-danger rounded-3 @enderror">
                                    <textarea id="settings-api-private"
                                              wire:model="settings.api.privateKey"
                                              wire:change="apiOptionUpdated('settings.api.privateKey')"
                                              type="text"
                                              class="form-control no-padding"></textarea>
                            </div>
                            @error('settings.api.privateKey')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="algorithm" class="form-label">{{ __('Algorithm') }}</label>
                            <select id="algorithm" class="form-select @error('settings.api.algorithm') border border-danger rounded-3 @enderror" wire:model="settings.api.algorithm" wire:change="apiOptionUpdated('settings.api.algorithm')">
                                <option value="">{{ __('Select Algorithm') }}</option>
                                <option value="1">{{ __('SHA1') }}</option>
                                <option value="2">{{ __('MD5') }}</option>
                                <option value="3">{{ __('MD4') }}</option>
                                <option value="6">{{ __('SHA224') }}</option>
                                <option value="7">{{ __('SHA256') }}</option>
                                <option value="8">{{ __('SHA384') }}</option>
                                <option value="9">{{ __('SHA512') }}</option>
                                <option value="10">{{ __('RMD160') }}</option>
                            </select>

                            @error('settings.api.algorithm')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="settings-api-blockedIPs">{{ __('Blocked IPs') }}</label>
                            <div class="@error('settings.api.blockedIPs') border border-danger rounded-3 @enderror">
                                    <textarea id="settings-api-blockedIPs"
                                              wire:model="settings.api.blockedIPs"
                                              wire:change="apiOptionUpdated('settings.api.blockedIPs')"
                                              type="text"
                                              class="form-control no-padding"></textarea>
                            </div>
                            @error('settings.api.blockedIPs')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="settings-api-blockedIdentifiers">{{ __('Blocked Identifiers') }}</label>
                            <div class="@error('settings.api.blockedIdentifiers') border border-danger rounded-3 @enderror">
                                    <textarea id="settings-api-blockedIdentifiers"
                                              wire:model.debounce="settings.api.blockedIdentifiers"
                                              wire:change.debounce="apiOptionUpdated('settings.api.blockedIdentifiers')"
                                              type="text"
                                              class="form-control no-padding"></textarea>
                            </div>
                            @error('settings.api.blockedIdentifiers')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="settings-api-passphrase">{{ __('Download Endpoint Accepted Useragent') }}</label>
                            <div class="@error('settings.api.acceptedUseragent') border border-danger rounded-3 @enderror">
                                <input id="settings-api-acceptedUseragent" wire:model="settings.api.acceptedUseragent" wire:change="apiOptionUpdated('settings.api.acceptedUseragent')" type="text" class="form-control no-padding">
                            </div>
                            @error('settings.api.acceptedUseragent')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-3 mb-3">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>

            <div class="card mt-3" id="envato">
                <form wire:submit.prevent="saveEnvatoSettings">
                    <div class="card-header">
                        <h5>{{ __('Envato') }}</h5>
                    </div>
                    <div class="card-body pt-0">
                        <div class="mb-3">
                            <label for="product-ui-brand">{{ __('Personal Token') }}</label>
                            <div class="@error('settings.ui.brand') border border-danger rounded-3 @enderror">
                                <input id="envato-personal-token " wire:model="settings.envato.personalToken" wire:change="envatoOptionUpdated('settings.envato.personalToken')" type="text" class="form-control no-padding">
                            </div>
                            @error('settings.envato.personalToken')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="item-published-container">{{ __('Envato Product') }}</label>
                            <div id="item-published-container" class="form-check form-switch ps-0">
                                <input wire:model="settings.envato.createProduct" wire:change="envatoOptionUpdated('settings.envato.createProduct')" class="form-check-input ms-auto" type="checkbox" id="settings-envato-createProduct">
                                <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                    {{ __("Create The Product If It Doesn't Exist.") }}
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-3 mb-3">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>

            <div class="card mt-3" id="logging">
                <form wire:submit.prevent="saveLoggingSettings">
                    <div class="card-header">
                        <h5>{{ __('Logging') }}</h5>
                    </div>
                    <div class="card-body pt-0">
                        <div class="mb-3">
                            <label for="item-published-container">{{ __('Dashboard Activity') }}</label>
                            <div id="item-published-container" class="form-check form-switch ps-0">
                                <input wire:model="settings.logging.dashboardActivity" wire:change="loggingOptionUpdated('settings.logging.dashboardActivity')" class="form-check-input ms-auto" type="checkbox" id="settings-logging-dashboard-activity">
                                <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                    {{ __("Log Dashboard Activities.") }}
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="item-published-container">{{ __('API Calls') }}</label>
                            <div id="item-published-container" class="form-check form-switch ps-0">
                                <input wire:model="settings.logging.apiCalls" wire:change="loggingOptionUpdated('settings.logging.apiCalls')" class="form-check-input ms-auto" type="checkbox" id="settings-logging-api-calls">
                                <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                    {{ __("API Calls.") }}
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="item-published-container">{{ __('Failed API Calls') }}</label>
                            <div id="item-published-container" class="form-check form-switch ps-0">
                                <input wire:model="settings.logging.failedApiCalls" wire:change="loggingOptionUpdated('settings.logging.failedApiCalls')" class="form-check-input ms-auto" type="checkbox" id="settings-logging-failed-api-calls">
                                <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                    {{ __("Failed API Calls.") }}
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="item-published-container">{{ __('Blocklisted API Calls') }}</label>
                            <div id="item-published-container" class="form-check form-switch ps-0">
                                <input wire:model="settings.logging.blocklistedApiCalls" wire:change="loggingOptionUpdated('settings.logging.blocklistedApiCalls')" class="form-check-input ms-auto" type="checkbox" id="settings-logging-blocklisted-api-calls">
                                <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                    {{ __("Blocklisted API Calls.") }}
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-3 mb-3">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>

            @if(!\Config::get( 'app.is_demo', false ))
                <div class="card mt-3" id="keevault">
                    <form wire:submit.prevent="saveKeevaultSettings">
                        <div class="card-header">
                            <h5>{{ __('Keevault License') }}</h5>
                        </div>
                        <div class="card-body pt-0">
                            <div class="mb-3">
                                <label for="product-productData-purchaseCode">{{ __('Purchase Code') }}</label>
                                <div class="@error('settings.productData.purchaseCode') border border-danger rounded-3 @enderror">
                                    <input id="settings-productData-purchaseCode" wire:model="settings.productData.purchaseCode" wire:change="keevaultOptionUpdated('settings.productData.purchaseCode')" type="text" class="form-control no-padding">
                                </div>
                                @error('settings.productData.purchaseCode')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-3 mb-3">{{ __('Save') }}</button>
                        </div>
                    </form>
                </div>
            @endif

        </div>
    </div>

    <small class="float-end">
        @foreach(getKeevaultProductInfo() as $key => $value)
            <strong>{{ $value['displayName'] }}:</strong> {{ $value['value'] }}
        @endforeach
    </small>
</div>
