@section('page-title')
    {{ __('Logs') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('logs') }}">
            {{ __('Logs') }}
        </a>
    </li>

    <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
        {{ __('Management') }}
    </li>
@endsection

<div class="row">
    <div class="col-12">
        <div class="card mb-4 mx-4">
            <ul class="list-group list-group-flush" x-data="{ showFilterOptions: false, showBulkOptions: false, showPurgeOptions: false }">
                <li class="list-group-item">
                    <div class="float-start">
                        <h5 class="card-title m-0">
                            @yield('page-title')
                        </h5>
                    </div>
                </li>
                <li class="list-group-item">
                    <a href="#" class="btn btn-action mb-0" x-on:click="showBulkOptions = !showBulkOptions">
                        <span x-show="!showBulkOptions" class="btn-inner--text">{{ __('Bulk Actions') }}</span>
                        <span x-show="showBulkOptions" class="btn-inner--text">{{ __('Hide Bulk Actions') }}</span>
                    </a>
                    <a href="#" class="btn btn-action mb-0" x-on:click="showPurgeOptions = !showPurgeOptions">
                        <span x-show="!showPurgeOptions" class="btn-inner--text">{{ __('Purge Logs') }}</span>
                        <span x-show="showPurgeOptions" class="btn-inner--text">{{ __('Hide Purge Logs') }}</span>
                    </a>
                    <a href="#" class="btn btn-action mb-0" x-on:click="showFilterOptions = !showFilterOptions">
                        <span x-show="!showFilterOptions" class="btn-inner--text"><i class="fas fa-filter"></i></span>
                        <span x-show="showFilterOptions" class="btn-inner--text">{{ __('Hide Filters') }}</span>
                    </a>
                </li>

                <li class="list-group-item" x-show="showFilterOptions">
                    @include('common.filter-search')
                </li>

                <li class="list-group-item" x-show="showBulkOptions">
                    <form class="form-inline" wire:submit.prevent="bulkActions">
                        <button x-on:click="bulkDelete()" type="button" class="btn btn-action-apply btn-action-danger me-2">
                            <span class="btn-inner--text">{{ __('Delete') }}</span>
                        </button>
                    </form>
                </li>

                <li class="list-group-item" x-show="showPurgeOptions">
                    <form class="form-inline" wire:submit.prevent="bulkActions">
                        <select id="purge-logs-group" class="form-select form-select-sm">
                            <option value="" selected>{{ __('Log Group') }}</option>
                            <option value="all">{{ __('All Logs') }}</option>
                            <option value="dashboardActivity">{{ __('Dashboard Activity') }}</option>
                            <option value="apiCalls">{{ __('Api Calls') }}</option>
                            <option value="failedApiCalls">{{ __('Failed Api Calls') }}</option>
                            <option value="blocklistedApiCalls">{{ __('Blocklisted Api Calls') }}</option>
                        </select>

                        <select id="purge-logs-date" class="form-select form-select-sm">
                            <option value="" selected>{{ __('Older Than') }}</option>
                            <option value="all">{{ __('All Logs') }}</option>
                            <option value="30">{{ __('30 Days') }}</option>
                            <option value="60">{{ __('60 Days') }}</option>
                            <option value="180">{{ __('180 Days') }}</option>
                            <option value="365">{{ __('365 Days') }}</option>
                        </select>

                        <button x-on:click="purgeLogs()" type="button" class="btn btn-action-apply btn-action-danger me-2">
                            <span class="btn-inner--text">{{ __('Purge') }}</span>
                        </button>
                    </form>
                </li>

                <li class="list-group-item p-0"></li>
            </ul>
            <div class="card-body px-0 pt-0 pb-2">
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                        <tr>
                            <th class="text-xxs opacity-7">
                                <input type="checkbox" id="bulk-action-checkbox">
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                {{ __('ID') }}
                            </th>
                            <th class="text-secondary text-uppercase  text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Action') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Identifier') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('IP Address') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Data') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Created At') }}
                            </th>
                        </tr>
                        </thead>
                        <tbody>

                        @if($items->count() > 0)
                            @foreach($items as $item)
                                <tr>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">
                                            <input type="checkbox" class="bulk-action-checkbox" value="{{ $item->id }}">
                                        </p>
                                    </td>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->id }}</p>
                                    </td>
                                    <td class="text-start text-xs font-weight-bold">
                                        {{ $item->getDescription() }}
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->getIdentifierDescription() }}</p>
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->ip_address }}</p>
                                    </td>
                                    <td class="text-start">
                                        @php($data = json_decode($item->data))
                                        @if($data)
												<?php printArray( $data ); ?>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ formatDatetime($item->created_at) }}</p>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="ps-4" colspan="8">
                                    <p class="text-center text-secondary text-xs font-weight-bold mb-0">{{ __('No logs found') }}</p>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>

            {{ $items->links() }}
        </div>
    </div>

    @include('common.modal-delete-item',  ['name' => 'log'])
    @include('common.confirm-bulk-action')
    @include('common.confirm-purge-action')
</div>

@push('styles')
    <style>
        .border-left {
            position: relative; /* Position relative to the parent */
        }

        .border-left::before {
            content: "";
            position: absolute;
            left: 0;
            top: 30px;
            width: 2px;
            height: calc(100% - 45px);
            border-left: 2px dotted #c4c4c4;
        }
    </style>
@endpush