<div wire:ignore.self class="modal fade" id="importItemsModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="importItemsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="importItems" id="importItemsForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{ __('Import License Keys') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="products-select-import" class="form-label">{{ __('Product') }}</label>
                        <div id="products-select-import-container" wire:ignore>
                            <select id="products-select-import" class="form-select products-select"></select>
                        </div>
                        @error('productId')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="license-keys-input">{{ __('License Keys') }}</label>
                        <div class="@error('importLicenseKeys') border border-danger rounded-3 @enderror">
                            <textarea wire:ignore id="license-keys-input" wire:model="importLicenseKeys" wire:change="importItemsUpdated('importLicenseKeys')" type="text" class="form-control no-padding"></textarea>
                        </div>
                        @error('importLicenseKeys')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="ownerName">{{ __('Owner Name') }}</label>
                        <div class="@error('ownerName') border border-danger rounded-3 @enderror">
                            <input id="ownerName" wire:model="ownerName" wire:change="importItemsUpdated('ownerName')" type="text" class="form-control no-padding">
                        </div>
                        @error('ownerName')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="ownerEmail">{{ __('Owner Email') }}</label>
                        <div class="@error('ownerEmail') border border-danger rounded-3 @enderror">
                            <input id="ownerEmail" wire:model="ownerEmail" wire:change="importItemsUpdated('ownerEmail')" type="email" class="form-control no-padding">
                        </div>
                        @error('ownerEmail')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Activation Limit') }}</label>
                        <div class="@error('activationLimit') border border-danger rounded-3 @enderror">
                            <input id="activation-limit-input" wire:model="activationLimit" wire:change="importItemsUpdated('activationLimit')" type="text" class="form-control no-padding">
                        </div>
                        @error('activationLimit')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Validity (days)') }}</label>
                        <div class="@error('validity') border border-danger rounded-3 @enderror">
                            <input id="validity-input" wire:model="validity" wire:change="importItemsUpdated('validity')" type="text" class="form-control no-padding">
                        </div>
                        @error('validity')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="import-license-products-select" class="form-label">{{ __('Status') }}</label>
                        <select id="import-license-products-select" class="form-select products-select" wire:model="status" wire:change="importItemsUpdated('status')">
                            @foreach($statuses as $key => $value)
                                <option value="{{ $key }}">{{ $value['text'] }}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="import-items-btn" type="submit" class="btn btn-primary">{{ __('Import') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-import-modal', function (e) {
            let select = $('#products-select-import');
            select.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-import-container'),
                ajax: {
                    url: '{{ route('json-products') }}',
                    dataType: 'json',
                }
            });

            let data = select.select2("val");

            (@this()).set('productId', data);

            $('#importItemsModal').modal('show');
        });

        window.addEventListener('close-import-modal', function (e) {
            $('#importItemsModal').modal('hide');
        });

        $('#import-items-btn').on('click', function (e) {
            e.preventDefault();

            let data = $('#products-select-import').select2("val");

            (@this()).set('productId', data);
            Livewire.emit('importItems');
        });
    </script>
@endpush
