<div wire:ignore.self class="modal fade" id="addItemModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="addItemModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="createItem" id="addItemForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{ __('Create License Key') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="products-select" class="form-label">{{ __('Product') }}</label>
                        <div id="products-select-container" wire:ignore>
                            <select wire:ignore id="products-select" class="form-select products-select"></select>
                        </div>
                        @error('productId')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="license-key-input">{{ __('License Key') }}</label>
                        <div class="@error('licenseKey') border border-danger rounded-3 @enderror">
                            <input id="license-key-input" wire:model.blur="licenseKey" wire:change="createItemUpdated('licenseKey')" type="text" class="form-control no-padding">
                        </div>
                        @error('licenseKey')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="ownerName">{{ __('Owner Name') }}</label>
                        <div class="@error('ownerName') border border-danger rounded-3 @enderror">
                            <input id="ownerName" wire:model="ownerName" wire:change="createItemUpdated('ownerName')" type="text" class="form-control no-padding">
                        </div>
                        @error('ownerName')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="ownerEmail">{{ __('Owner Email') }}</label>
                        <div class="@error('ownerEmail') border border-danger rounded-3 @enderror">
                            <input id="ownerEmail" wire:model="ownerEmail" wire:change="createItemUpdated('ownerEmail')" type="email" class="form-control no-padding">
                        </div>
                        @error('ownerEmail')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Activation Limit') }}</label>
                        <div class="@error('activationLimit') border border-danger rounded-3 @enderror">
                            <input id="activation-limit-input" wire:model="activationLimit" wire:change="createItemUpdated('activationLimit')" type="text" class="form-control no-padding">
                        </div>
                        @error('activationLimit')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Validity (days)') }}</label>
                        <div class="@error('validity') border border-danger rounded-3 @enderror">
                            <input id="validity-input" wire:model="validity" wire:change="createItemUpdated('validity')" type="text" class="form-control no-padding">
                        </div>
                        @error('validity')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="create-license-products-select" class="form-label">{{ __('Status') }}</label>
                        <select id="create-license-products-select" class="form-select products-select" wire:model="status" wire:change="createItemUpdated('status')">
                            @foreach($statuses as $key => $value)
                                <option value="{{ $key }}">{{ $value['text'] }}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="create-item-btn" type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-create-modal', function (e) {
            let select = $('#products-select');
            select.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-container'),
                ajax: {
                    url: '{{ route('json-products') }}',
                    dataType: 'json',
                },
            });

            let data = select.select2("val");
            (@this()).set('productId', data);

            $('#addItemModal').modal('show');
        });

        window.addEventListener('close-create-modal', function (e) {
            $('#addItemModal').modal('hide');
        });

        $('#create-item-btn').on('click', function (e) {
            e.preventDefault();

            let data = $('#products-select').select2("val");

            (@this()).set('productId', data);
            Livewire.emit('createItem');
        });
    </script>
@endpush
