<div wire:ignore.self class="modal fade" id="addItemModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="addItemModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="createItem" id="addItemModalLabel">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{ __('Create Contract') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="mb-3">
                        <label for="product-apiKey">{{ __('Contract Key') }}</label>
                        <div class="@error('contractKey') border border-danger rounded-3 @enderror">
                            <input id="contract-Key" wire:model="contractKey" wire:change="createItemUpdated('contractKey')" type="text" class="form-control no-padding">
                        </div>
                        @error('contractKey')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="product-name">{{ __('Name') }}</label>
                        <div class="@error('name') border border-danger rounded-3 @enderror">
                            <input id="contract-name" wire:model="name" wire:change="createItemUpdated('name')" type="text" class="form-control no-padding">
                        </div>
                        <small id="contract-name-help" class="form-text text-muted">{{ __('Displays in the license keys table to identify keys linked to this contract.') }}</small>
                        @error('name')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="product-description">{{ __('Information') }}</label>
                        <div class="@error('information') border border-danger rounded-3 @enderror">
                            <textarea id="contract-information" wire:model="information" wire:change="createItemUpdated('information')" class="form-control no-padding"></textarea>
                        </div>
                        @error('information')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="products-select-create" class="form-label">{{ __('Product') }}</label>
                        <div id="products-select-create-container" wire:ignore>
                            <select id="products-select-create" class="form-select products-select"></select>
                        </div>
                        @error('productId')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="validity-input">{{ __('License Keys Quantity') }}</label>
                        <div class="@error('licenseKeysQuantity') border border-danger rounded-3 @enderror">
                            <input id="quantity-input" wire:model="licenseKeysQuantity" wire:change="createItemUpdated('licenseKeysQuantity')" type="number" class="form-control no-padding">
                        </div>
                        @error('licenseKeysQuantity')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="create-contract-status" class="form-label">{{ __('Status') }}</label>
                        <select id="create-contract-status" class="form-select products-select" wire:model="status" wire:change="createItemUpdated('status')">
                            <option value="active">{{ __('Active') }}</option>
                            <option value="inactive">{{ __('Inactive') }}</option>
                        </select>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <tbody>
                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get Info') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Get contract information') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetInfo">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Can Generate') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Generate license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGenerate">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Can Destroy') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Destroy license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDestroy">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Can Destroy All') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Destroy all contract license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDestroyAll">
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="create-btn" type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-create-modal', function (e) {
            let select = $('#products-select-create');
            let addItemModal = $('#addItemModal');
            select.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-create-container'),
                ajax: {
                    url: '{{ route('json-products') }}',
                    dataType: 'json',
                },
            });

            let data = select.select2("val");

            (@this()).set('productId', data);

            $(addItemModal).modal('show');
        });

        window.addEventListener('close-create-modal', function (e) {
            $('#addItemModal').modal('hide');
        });

        $('#create-btn').on('click', function (e) {
            e.preventDefault();

            let data = $('#products-select-create').select2("val");

            (@this()).set('productId', data);
            Livewire.emit('createItem');
        });
    </script>
@endpush
