@section('page-title')
    {{ __('API Keys') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('api-keys') }}">
            {{ __('API Keys') }}
        </a>
    </li>

    <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
        {{ __('Management') }}
    </li>
@endsection

<div class="row">
    <div class="col-12">
        <div class="card mb-4 mx-4">
            <ul class="list-group list-group-flush" x-data="{ showFilterOptions: false, showBulkOptions: false }">
                <li class="list-group-item">
                    <div class="float-start">
                        <h5 class="card-title m-0">
                            @yield('page-title')
                        </h5>
                    </div>
                    <div class="float-end">
                        <a wire:click="openCreateModal" href="#" class="btn btn-action mb-0">
                                    <span class="btn-inner--icon me-1">
                                        <i class="fas fa-plus-circle"></i>
                                    </span>
                            <span class="btn-inner--text">{{ __('Add') }} @yield('page-title')</span>
                        </a>
                    </div>
                </li>
                <li class="list-group-item">
                    <a href="#" class="btn btn-action mb-0" x-on:click="showBulkOptions = !showBulkOptions">
                        <span x-show="!showBulkOptions" class="btn-inner--text">{{ __('Bulk Actions') }}</span>
                        <span x-show="showBulkOptions" class="btn-inner--text">{{ __('Hide Bulk Actions') }}</span>
                    </a>
                    <a href="#" class="btn btn-action mb-0" x-on:click="showFilterOptions = !showFilterOptions">
                        <span x-show="!showFilterOptions" class="btn-inner--text"><i class="fas fa-filter"></i></span>
                        <span x-show="showFilterOptions" class="btn-inner--text">{{ __('Hide Filters') }}</span>
                    </a>
                </li>

                <li class="list-group-item" x-show="showFilterOptions">
                    @include('common.filter-search')
                </li>

                <li class="list-group-item" x-show="showBulkOptions">
                    <form class="form-inline" wire:submit.prevent="bulkActions">
                        <button x-on:click="bulkDelete()" type="button" class="btn btn-action-apply btn-action-danger me-2">
                            <span class="btn-inner--text">{{ __('Delete') }}</span>
                        </button>

                        <select id="bulk-change-status" x-on:change="bulkChangeStatus()" class="form-control form-control-sm x-fit-content">
                            <option value="" selected>{{ __('Change Status') }}</option>
                            <option value="active">{{ __('Active') }}</option>
                            <option value="inactive">{{ __('Inactive') }}</option>
                        </select>
                    </form>
                </li>

                <li class="list-group-item p-0"></li>
            </ul>
            <div class="card-body px-0 pt-0 pb-2">
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                        <tr>
                            <th class="text-xxs opacity-7">
                                <input type="checkbox" id="bulk-action-checkbox">
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                {{ __('ID') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('API Key') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Description') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('IP Address') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Status') }}
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                {{ __('Created') }}
                            </th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                {{ __('Action') }}
                            </th>
                        </tr>
                        </thead>
                        <tbody>

                        @if($items->count() > 0)
                            @foreach($items as $item)
                                <tr>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">
                                            <input type="checkbox" class="bulk-action-checkbox" value="{{ $item->id }}">
                                        </p>
                                    </td>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->id }}</p>
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->api_key }}</p>
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->description != '' ? $item->description : '-' }}</p>
                                    </td>
                                    <td class="text-start">
                                        <p class="text-xs font-weight-bold mb-0">{{ $item->ip_address != '' ? $item->ip_address : '-' }}</p>
                                    </td>
                                    <td class="text-start">
                                            <span class="text-capitalize text-up text-secondary text-xs font-weight-bold">
                                                @if($item->is_active)
                                                    <span class="badge badge-sm bg-gradient-success">{{ __('On') }}</span>
                                                @else
                                                    <span class="badge badge-sm bg-gradient-secondary">{{ __('Off') }}</span>
                                                @endif
                                            </span>
                                    </td>
                                    <td class="text-start">
                                        <span class="text-secondary text-xs font-weight-bold">{{ formatDatetime($item->created_at) }}</span>
                                    </td>
                                    <td class="text-center text-sm" x-data>
                                        <a wire:click="openUpdateModal({{ $item->id }})" href="#" class="me-3">
                                            <i class="cursor-pointer fas fa-edit text-secondary"></i>
                                        </a>

                                        <a x-on:click="openDeleteModal({{ $item->id }})" href="#">
                                            <i class="cursor-pointer fas fa-trash text-secondary"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="ps-4" colspan="9">
                                    <p class="text-center text-secondary text-xs font-weight-bold mb-0">{{ __('No products found') }}</p>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>

            {{ $items->links() }}
        </div>
    </div>

    @include('livewire.api-keys.modal-add-item')
    @include('livewire.api-keys.modal-update-item')
    @include('common.modal-delete-item', ['name' => 'api Key'])
    @include('common.confirm-bulk-action')
</div>
