<div wire:ignore class="modal fade" id="deleteItemModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteItemModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="deleteItem" id="deleteItemForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-capitalize" id="staticBackdropLabel">{{ sprintf(__('Delete %s'), $name) }}</h5>
                </div>
                <div class="modal-body">
                    {{ sprintf(__('Delete %s'), $name) }} #<span id="delete-item-id"></span>

                    @if(isset($warning))
                        <p class="mb-0 mt-3 text-danger">{{ $warning }}</p>
                    @endif
                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="delete-item-btn" type="submit" class="btn btn-primary">{{ __('Delete') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        function openDeleteModal(id) {
            $('#deleteItemModal').modal('show');
            document.getElementById('delete-item-id').innerText = id;

            (@this()).set('deleteId', id);
        }

        window.addEventListener('close-delete-modal', event => {
            $('#deleteItemModal').modal('hide');
        });
    </script>
@endpush
