<div class="modal fade" id="confirmPurgeActionModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="confirmPurgeActionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="confirmPurgeActionModalLabel">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Purge Action') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    {{ __('Purge logs?') }}
                </div>
                <div class="modal-footer" x-data="">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button x-on:click="confirmPurgeAction()" type="button" class="btn btn-primary">{{ __('Confirm') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        document.addEventListener('open-confirm-purge-action', event => {
            $('#confirmPurgeActionModal').modal('show');
        });

        document.addEventListener('close-confirm-purge-action', event => {
            $('#confirmPurgeActionModal').modal('hide');
        });

        document.addEventListener('reset-purge-input', event => {
            $("#purge-logs").val('');
        });

        function confirmPurgeAction() {
            Livewire.emit('purgeActionConfirmed');
        }

        function purgeLogs() {
            (@this()).set('purgeActionGroup', $("#purge-logs-group").val());
            (@this()).set('purgeActionDate', $("#purge-logs-date").val());

            Livewire.emit('purgeAction');
        }
    </script>
@endpush
