"use strict";
(function () {
    let isWindows = navigator.platform.indexOf('Win') > -1;

    if (isWindows) {
        if (document.querySelector('#sidenav-scrollbar')) {
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), {
                damping: '0.5'
            });
        }

        if (document.getElementsByClassName('main-content')[0]) {
            let mainpanel = document.querySelector('.main-content');
            let ps = new PerfectScrollbar(mainpanel, {
                suppressScrollX: true
            });
        }

        if (document.getElementsByClassName('sidenav')[0]) {
            let sidebar = document.querySelector('.sidenav');
            let ps1 = new PerfectScrollbar(sidebar, {
                suppressScrollX: true
            });
        }
    }


// Verify navbar blur on scroll
    navbarBlurOnScroll('navbarBlur');


// initialization of Tooltips
    let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    });

// Fixed Plugin

    if (document.querySelector('.fixed-plugin')) {
        let fixedPlugin = document.querySelector('.fixed-plugin');
        let fixedPluginButton = document.querySelector('.fixed-plugin-button');
        let fixedPluginButtonNav = document.querySelector('.fixed-plugin-button-nav');
        let fixedPluginCard = document.querySelector('.fixed-plugin .card');
        let fixedPluginCloseButton = document.querySelectorAll('.fixed-plugin-close-button');
        let navbar = document.getElementById('navbarBlur');
        let buttonNavbarFixed = document.getElementById('navbarFixed');

        if (fixedPluginButton) {
            fixedPluginButton.onclick = function () {
                if (!fixedPlugin.classList.contains('show')) {
                    fixedPlugin.classList.add('show');
                } else {
                    fixedPlugin.classList.remove('show');
                }
            }
        }

        if (fixedPluginButtonNav) {
            fixedPluginButtonNav.onclick = function () {
                if (!fixedPlugin.classList.contains('show')) {
                    fixedPlugin.classList.add('show');
                } else {
                    fixedPlugin.classList.remove('show');
                }
            }
        }

        fixedPluginCloseButton.forEach(function (el) {
            el.onclick = function () {
                fixedPlugin.classList.remove('show');
            }
        })

        document.querySelector('body').onclick = function (e) {
            if (e.target != fixedPluginButton && e.target != fixedPluginButtonNav && e.target.closest('.fixed-plugin .card') != fixedPluginCard) {
                fixedPlugin.classList.remove('show');
            }
        }

        if (navbar) {
            if (navbar.getAttribute('navbar-scroll') == 'true') {
                buttonNavbarFixed.setAttribute("checked", "true");
            }
        }

    }

// Tabs navigation

    let total = document.querySelectorAll('.nav-pills');

    total.forEach(function (item, i) {
        let moving_div = document.createElement('div');
        let first_li = item.querySelector('li:first-child .nav-link');
        let tab = first_li.cloneNode();
        tab.innerHTML = "-";

        moving_div.classList.add('moving-tab', 'position-absolute', 'nav-link');
        moving_div.appendChild(tab);
        item.appendChild(moving_div);

        let list_length = item.getElementsByTagName("li").length;

        moving_div.style.padding = '0px';
        moving_div.style.width = item.querySelector('li:nth-child(1)').offsetWidth + 'px';
        moving_div.style.transform = 'translate3d(0px, 0px, 0px)';
        moving_div.style.transition = '.5s ease';

        item.onmouseover = function (event) {
            let target = getEventTarget(event);
            let li = target.closest('li'); // get reference
            if (li) {
                let nodes = Array.from(li.closest('ul').children); // get array
                let index = nodes.indexOf(li) + 1;
                item.querySelector('li:nth-child(' + index + ') .nav-link').onclick = function () {
                    moving_div = item.querySelector('.moving-tab');
                    let sum = 0;
                    if (item.classList.contains('flex-column')) {
                        for (let j = 1; j <= nodes.indexOf(li); j++) {
                            sum += item.querySelector('li:nth-child(' + j + ')').offsetHeight;
                        }
                        moving_div.style.transform = 'translate3d(0px,' + sum + 'px, 0px)';
                        moving_div.style.height = item.querySelector('li:nth-child(' + j + ')').offsetHeight;
                    } else {
                        for (let j = 1; j <= nodes.indexOf(li); j++) {
                            sum += item.querySelector('li:nth-child(' + j + ')').offsetWidth;
                        }
                        moving_div.style.transform = 'translate3d(' + sum + 'px, 0px, 0px)';
                        moving_div.style.width = item.querySelector('li:nth-child(' + index + ')').offsetWidth + 'px';
                    }
                }
            }
        }
    });


// Tabs navigation resize

    window.addEventListener('resize', function (event) {
        total.forEach(function (item, i) {
            item.querySelector('.moving-tab').remove();
            let moving_div = document.createElement('div');
            let tab = item.querySelector(".nav-link.active").cloneNode();
            tab.innerHTML = "-";

            moving_div.classList.add('moving-tab', 'position-absolute', 'nav-link');
            moving_div.appendChild(tab);

            item.appendChild(moving_div);

            moving_div.style.padding = '0px';
            moving_div.style.transition = '.5s ease';

            let li = item.querySelector(".nav-link.active").parentElement;

            if (li) {
                let nodes = Array.from(li.closest('ul').children); // get array
                let index = nodes.indexOf(li) + 1;

                let sum = 0;
                if (item.classList.contains('flex-column')) {
                    for (let j = 1; j <= nodes.indexOf(li); j++) {
                        sum += item.querySelector('li:nth-child(' + j + ')').offsetHeight;
                    }
                    moving_div.style.transform = 'translate3d(0px,' + sum + 'px, 0px)';
                    moving_div.style.width = item.querySelector('li:nth-child(' + index + ')').offsetWidth + 'px';
                    moving_div.style.height = item.querySelector('li:nth-child(' + j + ')').offsetHeight;
                } else {
                    for (let j = 1; j <= nodes.indexOf(li); j++) {
                        sum += item.querySelector('li:nth-child(' + j + ')').offsetWidth;
                    }
                    moving_div.style.transform = 'translate3d(' + sum + 'px, 0px, 0px)';
                    moving_div.style.width = item.querySelector('li:nth-child(' + index + ')').offsetWidth + 'px';

                }
            }
        });

        if (window.innerWidth < 991) {
            total.forEach(function (item, i) {
                if (!item.classList.contains('flex-column')) {
                    item.classList.add('flex-column', 'on-resize');
                }
            });
        } else {
            total.forEach(function (item, i) {
                if (item.classList.contains('on-resize')) {
                    item.classList.remove('flex-column', 'on-resize');
                }
            })
        }
    });


    function getEventTarget(e) {
        e = e || window.event;
        return e.target || e.srcElement;
    }

// End tabs navigation


//Set Sidebar Color
    window.sidebarColor = function (a) {
        let parent = a.parentElement.children;
        let color = a.getAttribute("data-color");

        for (let i = 0; i < parent.length; i++) {
            parent[i].classList.remove('active');
        }

        if (!a.classList.contains('active')) {
            a.classList.add('active');
        } else {
            a.classList.remove('active');
        }

        let sidebar = document.querySelector('.sidenav');
        sidebar.setAttribute("data-color", color);

        if (document.querySelector('#sidenavCard')) {
            let sidenavCard = document.querySelector('#sidenavCard');
            let sidenavCardClasses = ['card', 'card-background', 'shadow-none', 'card-background-mask-' + color];
            sidenavCard.className = '';
            sidenavCard.classList.add(...sidenavCardClasses);

            let sidenavCardIcon = document.querySelector('#sidenavCardIcon');
            let sidenavCardIconClasses = ['ni', 'ni-diamond', 'text-gradient', 'text-lg', 'top-0', 'text-' + color];
            sidenavCardIcon.className = '';
            sidenavCardIcon.classList.add(...sidenavCardIconClasses);
        }

    }

// Set Navbar Fixed
    window.navbarFixed = function (el) {
        let classes = ['position-sticky', 'blur', 'shadow-blur', 'mt-4', 'left-auto', 'top-1', 'z-index-sticky'];
        let navbar = document.getElementById('navbarBlur');

        if (!el.getAttribute("checked")) {
            navbar.classList.add(...classes);
            navbar.setAttribute('navbar-scroll', 'true');
            navbarBlurOnScroll('navbarBlur');
            el.setAttribute("checked", "true");
        } else {
            navbar.classList.remove(...classes);
            navbar.setAttribute('navbar-scroll', 'false');
            navbarBlurOnScroll('navbarBlur');
            el.removeAttribute("checked");
        }
    };

// Navbar blur on scroll

    function navbarBlurOnScroll(id) {
        let navbar = document.getElementById(id);
        let navbarScrollActive = navbar ? navbar.getAttribute("navbar-scroll") : false;
        let scrollDistance = 5;
        let classes = ['position-sticky', 'blur', 'shadow-blur', 'mt-4', 'left-auto', 'top-1', 'z-index-sticky'];
        let toggleClasses = ['shadow-none'];

        if (navbarScrollActive == 'true') {
            window.onscroll = debounce(function () {
                if (window.scrollY > scrollDistance) {
                    blurNavbar();
                } else {
                    transparentNavbar();
                }
            }, 10);
        } else {
            window.onscroll = debounce(function () {
                transparentNavbar();
            }, 10);
        }

        function blurNavbar() {
            navbar.classList.add(...classes)
            navbar.classList.remove(...toggleClasses)

            toggleNavLinksColor('blur');
        }

        function transparentNavbar() {
            if (navbar) {
                navbar.classList.remove(...classes)
                navbar.classList.add(...toggleClasses)

                toggleNavLinksColor('transparent');
            }
        }

        function toggleNavLinksColor(type) {
            let navLinks = document.querySelectorAll('.navbar-main .nav-link')
            let navLinksToggler = document.querySelectorAll('.navbar-main .sidenav-toggler-line')

            if (type === "blur") {
                navLinks.forEach(element => {
                    element.classList.remove('text-body')
                });

                navLinksToggler.forEach(element => {
                    element.classList.add('bg-dark')
                });
            } else if (type === "transparent") {
                navLinks.forEach(element => {
                    element.classList.add('text-body')
                });

                navLinksToggler.forEach(element => {
                    element.classList.remove('bg-dark')
                });
            }
        }
    }


// Debounce Function
// Returns a function, that, as long as it continues to be invoked, will not
// be triggered. The function will be called after it stops being called for
// N milliseconds. If `immediate` is passed, trigger the function on the
// leading edge, instead of the trailing.
    function debounce(func, wait, immediate) {
        let timeout;
        return function () {
            let context = this,
                args = arguments;
            let later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            let callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    };

//Set Sidebar Type
    function sidebarType(a) {
        let parent = a.parentElement.children;
        let color = a.getAttribute("data-class");

        let colors = [];

        for (let i = 0; i < parent.length; i++) {
            parent[i].classList.remove('active');
            colors.push(parent[i].getAttribute('data-class'));
        }

        if (!a.classList.contains('active')) {
            a.classList.add('active');
        } else {
            a.classList.remove('active');
        }

        let sidebar = document.querySelector('.sidenav');

        for (let i = 0; i < colors.length; i++) {
            sidebar.classList.remove(colors[i]);
        }

        sidebar.classList.add(color);
    }


// Toggle Sidenav
    let iconNavbarSidenav = document.getElementById('iconNavbarSidenav');
    let iconSidenav = document.getElementById('iconSidenav');
    let sidenav = document.getElementById('sidenav-main');
    let body = document.getElementsByTagName('body')[0];
    let className = 'g-sidenav-pinned';

    if (iconNavbarSidenav) {
        iconNavbarSidenav.addEventListener("click", toggleSidenav);
    }

    if (iconSidenav) {
        iconSidenav.addEventListener("click", toggleSidenav);
    }

    function toggleSidenav() {
        if (body.classList.contains(className)) {
            body.classList.remove(className);
            setTimeout(function () {
                sidenav.classList.remove('bg-white');
            }, 100);
            sidenav.classList.remove('bg-transparent');

        } else {
            body.classList.add(className);
            sidenav.classList.add('bg-white');
            sidenav.classList.remove('bg-transparent');
            iconSidenav.classList.remove('d-none');
        }
    }

// Deactivate sidenav type buttons on resize and small screens
    window.addEventListener("resize", sidenavTypeOnResize);
    window.addEventListener("load", sidenavTypeOnResize);

    function sidenavTypeOnResize() {
        let elements = document.querySelectorAll('[onclick="sidebarType(this)"]');
        if (window.innerWidth < 1200) {
            elements.forEach(function (el) {
                el.classList.add('disabled');
            });
        } else {
            elements.forEach(function (el) {
                el.classList.remove('disabled');
            });
        }
    }

    let bulkSelect = document.getElementById('bulk-action-checkbox');

    if (bulkSelect) {
        $('#bulk-action-checkbox').change(function () {
            if (this.checked) {
                $('.bulk-action-checkbox').prop('checked', true);
            } else {
                $('.bulk-action-checkbox').prop('checked', false);
            }
        });
    }

})();
