<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void {
		Schema::table( 'api_keys', function ( Blueprint $table ) {
			$table->boolean( 'can_create_contract' )->default( false );
			$table->boolean( 'can_update_contract' )->default( false );
			$table->boolean( 'can_delete_contract' )->default( false );
			$table->boolean( 'can_get_all_contracts' )->default( false );
		} );
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::table( 'api_keys', function ( Blueprint $table ) {
			$table->dropColumn( 'can_create_contract' );
			$table->dropColumn( 'can_update_contract' );
			$table->dropColumn( 'can_delete_contract' );
			$table->dropColumn( 'can_get_all_contracts' );
		} );
	}
};
