<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void {
		Schema::create( 'contracts', function ( Blueprint $table ) {
			$table->id();
			$table->string( 'name' );
			$table->text( 'information' );
			$table->string( 'contract_key' )->unique();
			$table->unsignedInteger( 'license_keys_quantity' );
			$table->unsignedBigInteger( 'product_id' );
			$table->boolean( 'can_get_info' )->default( true );
			$table->boolean( 'can_generate' )->default( true );
			$table->boolean( 'can_destroy' )->default( true );
			$table->boolean( 'can_destroy_all' )->default( false );
			$table->string( 'status' );
			$table->timestamps();
		} );
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::dropIfExists( 'contracts' );
	}
};
