<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'generators', function ( Blueprint $table ) {
            $table->id();
            $table->integer( 'product_id' )->unsigned();
            $table->string( 'method' );
            $table->string( 'prefix' )->nullable();
            $table->string( 'suffix' )->nullable();
            $table->string( 'function_name' )->nullable();
            $table->integer( 'number_of_chunks' )->default( 0 );
            $table->integer( 'chunk_length' )->default( 0 );
            $table->integer( 'activation_limit' )->default( 0 );
            $table->integer( 'validity' )->default( 0 );
            $table->boolean( 'status' );
            $table->string( 'charset' );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'generators' );
    }
};
