<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'settings', function ( Blueprint $table ) {
            $table->id();
            $table->string( 'group' );
            $table->string( 'name' );
            $table->text( 'value' )->nullable();

            $table->unique( [ 'group', 'name' ] );
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'settings' );
    }
};
