<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'license_keys', function ( Blueprint $table ) {
            $table->id();
            $table->integer( 'product_id' )->unsigned();
            $table->string( 'license_key' )->unique();
            $table->string( 'owner_name' )->nullable();
            $table->string( 'owner_email' )->nullable();
            $table->integer( 'activation_limit' )->default( 0 );
            $table->integer( 'validity' )->default( 0 );
            $table->timestamp( 'assigned_at' )->nullable();
            $table->string( 'status' )->default( 'available' );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'license_keys' );
    }
};
