<?php

namespace App\Models;

use App\Traits\Excludable;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class Product extends Model {
    use Excludable;

    protected $fillable = [
        'source',
        'name',
        'description',
        'require_non_expired',
        'external_reference',
        'status',
    ];

    protected $appends = [ 'meta_data' ];

    public function getMetaDataAttribute(): Collection {
        return $this->hasMany( Meta::class, 'item_id' )->select( [ 'key', 'value' ] )->where( 'type', 'product' )->get();
    }

}
