<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Log extends Model {
	public function getIdentifierDescription(): string {
		if ( ! isset( \App\Services\Log::$actions[ $this->action ] ) ) {
			return sprintf( __( 'Log action #%d not recognised' ), $this->action );
		}

		if ( \App\Services\Log::$actions[ $this->action ]['identifier_type'] == 'user_id' ) {
			$user = User::select( 'name' )->where( 'id', $this->identifier )->first();

			if ( $user ) {
				return '#' . $this->identifier . ' ' . $user->name;
			}

			return sprintf( __( 'User #%d not found' ), $this->identifier );
		} else if ( \App\Services\Log::$actions[ $this->action ]['identifier_type'] == 'api_key' ) {
			return sprintf( __( 'API Key: %s' ), $this->identifier );
		}

		return __( 'Identifier type not recognised' );
	}

	public function getDescription() {
		if ( ! isset( \App\Services\Log::$actions[ $this->action ] ) ) {
			return sprintf( __( 'Log action #%d not recognised' ), $this->action );
		}

		if ( isset( $data['endpoint'] ) && \App\Services\Log::$actions[ $this->action ]['identifier_type'] == 'api_key' ) {
			$data = json_decode( $this->data, true );

			return sprintf( \App\Services\Log::$actions[ $this->action ]['description'], $data['endpoint'] );
		}

		return \App\Services\Log::$actions[ $this->action ]['description'];
	}
}
