<?php

namespace App\Models;

use App\Traits\Excludable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Contract extends Model {
	use Excludable;

	protected $appends = [ 'license_keys_count' ];

	public function product(): BelongsTo {
		return $this->belongsTo( Product::class );
	}

	public function getLicenseKeysCountAttribute() {
		return LicenseKey::whereContractId( $this->id )->count();
	}
}
