<?php

namespace App\Http\Livewire;

use App\Services\Log;
use Livewire\Component;
use Schema;

class Telemetry extends Component {

    protected $listeners = [ 'filterItems' ];

    public $filterSearch, $bulkAction;

    public function filterItems(): void {
        $this->dispatchBrowserEvent( 'filter-done' );
    }

    public function render() {
        return view( 'livewire.telemetry.manage', [
            'items' => \App\Models\Telemetry::where( function ( $q ) {
                if ( $this->filterSearch != '' ) {
                    foreach ( Schema::getColumnListing( 'telemetry' ) as $column ) {
                        $q->orWhere( $column, 'like', '%' . $this->filterSearch . '%' );
                    }
                }
            } )->orderBy( 'id', 'DESC' )->paginate( getOption( 'ui', 'itemsPerTable', 10 ) )
        ] );
    }
}
