<?php

namespace App\Http\Livewire\Auth;

use App\Services\Log;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;
use App\Models\User;
use PHPGangsta_GoogleAuthenticator;

class Login extends Component {
    public string $email = '';
    public string $password = '';
    public string $twoFactorCode = '';
    public bool $rememberMe = false;
    public bool $showTwoFactor = false;
    public bool $isFirstAttempt = true;

    protected array $rules = [
        'email'    => 'required|email',
        'password' => 'required',
    ];

    public function mount(): void {
        if ( auth()->user() ) {
            redirect( '/dashboard' );
        }
    }

    public function login() {
        $this->validate();

        if ( $this->email && $this->password ) {
            $user = User::where( 'email', $this->email )->first();

            if ( $user && $user->is_2fa_enabled ) {
                if ( Hash::check( $this->password, $user->password ) ) {
                    $this->showTwoFactor = true;
                } else {
                    $this->showTwoFactor = false;
                }

                if ( $this->showTwoFactor ) {
                    if ( ( new PHPGangsta_GoogleAuthenticator() )->verifyCode( $user->two_factor_secret, $this->twoFactorCode, 2 ) ) {
                        if ( auth()->attempt( [ 'email' => $this->email, 'password' => $this->password ], $this->rememberMe ) ) {
                            $user = User::where( [ "email" => $this->email ] )->first();
                            auth()->login( $user, $this->rememberMe );

                            Log::add( '100', $user->id, request()->ip() );

                            return redirect()->intended( '/dashboard' );
                        }
                    } else {
                        if ( ! $this->isFirstAttempt ) {
                            Log::add( '101', $user->id, request()->ip(), [ 'email' => $this->email ] );

                            return $this->addError( 'twoFactorCode', __( 'Two factor authentication code is incorrect' ) );
                        }

                        $this->isFirstAttempt = false;
                    }
                } else {
                    Log::add( '102', $user->id, request()->ip(), [ 'email' => $this->email ] );

                    return $this->addError( 'email', trans( 'auth.failed' ) );
                }
            } else {
                if ( auth()->attempt( [ 'email' => $this->email, 'password' => $this->password ], $this->rememberMe ) ) {
                    $user = User::where( [ "email" => $this->email ] )->first();
                    auth()->login( $user, $this->rememberMe );

                    Log::add( '100', $user->id, request()->ip() );

                    return redirect()->intended( '/dashboard' );
                } else {
                    Log::add( '103', '0', request()->ip(), [ 'email' => $this->email ] );

                    return $this->addError( 'email', trans( 'auth.failed' ) );
                }
            }
        }

        return false;
    }

    public function render() {
        return view( 'livewire.auth.login' );
    }
}
