<?php

namespace App\Http\Controllers\Installer;

use App\Http\Controllers\Controller;
use Froiden\LaravelInstaller\Helpers\Reply;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Request;
use Session;

class PurchaseCodeController extends Controller {

	/**
	 * @return Application|Factory|View|\Illuminate\Foundation\Application
	 */
	public function purchaseCode() {
		return view( 'installer.purchase-code' );
	}

	public function purchaseCodeSave() {
		if ( isEnvatoPurchaseCode( Request::get( 'purchaseCode' ) ) ) {
			$purchaseCode = getEnvatoPurchase( Request::get( 'purchaseCode' ), '7ssHZPhSkG9KjoluecIjedwfQxOi9qZc' );

			if ( isset( $purchaseCode['buyer'] ) ) {
				Session::put('purchaseCode', Request::get( 'purchaseCode' ));

				return Reply::redirect( route( 'LaravelInstaller::environment' ), __( 'Valid purchase code' ) );
			}
		}

		return Reply::error( __( 'Invalid purchase code' ) );
	}
}
