<?php

namespace App\Http\Controllers\Installer;

use App\Models\Setting;
use Illuminate\Http\RedirectResponse;
use Illuminate\Routing\Controller;
use Froiden\LaravelInstaller\Helpers\DatabaseManager;
use Session;

class DatabaseController extends Controller {

	/**
	 * @var DatabaseManager
	 */
	private DatabaseManager $databaseManager;

	/**
	 * @param DatabaseManager $databaseManager
	 */
	public function __construct( DatabaseManager $databaseManager ) {
		$this->databaseManager = $databaseManager;
	}

	/**
	 * Migrate and seed the database.
	 *
	 * @return RedirectResponse
	 */
	public function database() {
		set_time_limit( 0 );
		$response = $this->databaseManager->migrateAndSeed();

		Setting::upsert( [ 'group' => 'productData', 'name' => 'purchaseCode', 'value' => Session::get( 'purchaseCode' ) ], [ 'group', 'name' ], [ 'value' ] );

		Session::forget( 'purchaseCode' );

		return redirect()->route( 'LaravelInstaller::final' )
		                 ->with( [ 'message' => $response ] );
	}
}
