<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Services\Api\V1\ResponseService;
use App\Services\Log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiController extends Controller {
	public function verify( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::verify( $request->license_key, $request->identifier, false, isset( $request->email ) ? $request->email : '' ) );
	}

	public function activate( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::activate( $request->license_key, $request->identifier, $request->ip(), isset( $request->post_url ) ? $request->post_url : '', isset( $request->owner_email ) ? $request->owner_email : '' ) );
	}

	public function deactivate( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::deactivate( $request->license_key, $request->identifier ) );
	}

	public function getLicenseKeyDetails( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::getLicenseKeyDetails( $request->license_key, $request->identifier ) );
	}

	public function accessDownloadables( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::accessDownloadables( $request->license_key, $request->identifier, $request->api_key ) );
	}

	public function download( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::download( $request->license_key, $request->identifier, $request->version );
	}

	public function assignLicenseKey( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::assignLicenseKey( $request->license_key, $request->owner_name, $request->owner_email ) );
	}

	public function randomAssignLicenseKey( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$generate = isset( $request->generate ) && $request->generate == 1;

		return ResponseService::respond( ResponseService::randomAssignLicenseKey( $request->product_id, $request->owner_name, $request->owner_email, abs( $request->quantity ), $generate ) );
	}

	public function randomAssignLicenseKeyQueued( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$generate = isset( $request->generate ) && $request->generate == 1;

		return ResponseService::respond( ResponseService::randomAssignLicenseKeysQueued( $request->product_id, $request->owner_name, $request->owner_email, abs( $request->quantity ), $generate, $request->webhook_url, $request->identifier ) );
	}

	public function assignAndActivateLicenseKey( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		ResponseService::assignLicenseKey( $request->license_key, $request->owner_name, $request->owner_email );

		return ResponseService::respond( ResponseService::activate( $request->license_key, $request->identifier, $request->ip(), isset( $request->post_url ) ? $request->post_url : '', isset( $request->owner_email ) ? $request->owner_email : '' ) );

	}

	public function createLicenseKey( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$licenseKeys = json_decode( $request->license_keys );

		$options = [
			'product_id'       => isset( $request->product_id ) ? $request->product_id : 0,
			'owner_name'       => isset( $request->owner_name ) ? $request->owner_name : '',
			'owner_email'      => isset( $request->owner_email ) ? $request->owner_email : '',
			'activation_limit' => isset( $request->activation_limit ) ? $request->activation_limit : 0,
			'validity'         => isset( $request->validity ) ? $request->validity : 0,
			'assigned_at'      => isset( $request->assigned_at ) ? $request->assigned_at : null,
			'status'           => isset( $request->status ) ? $request->status : 'available',
		];

		return ResponseService::respond( ResponseService::createLicenseKey( $licenseKeys, $options ) );
	}

	public function updateLicenseKey( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'product_id'       => isset( $request->product_id ) ? $request->product_id : null,
			'owner_name'       => isset( $request->owner_name ) ? $request->owner_name : null,
			'owner_email'      => isset( $request->owner_email ) ? $request->owner_email : null,
			'activation_limit' => isset( $request->activation_limit ) ? $request->activation_limit : null,
			'validity'         => isset( $request->validity ) ? $request->validity : null,
			'assigned_at'      => isset( $request->assigned_at ) ? $request->assigned_at : null,
			'status'           => isset( $request->status ) ? $request->status : null,
		];

		return ResponseService::respond( ResponseService::updateLicenseKey( $request->license_key, $options ) );
	}


	public function deleteLicenseKey( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::deleteLicenseKey( $request->license_key ) );
	}


	public function createProduct( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'source'              => isset( $request->source ) ? $request->source : 'internal',
			'name'                => isset( $request->name ) ? $request->name : '',
			'description'         => isset( $request->description ) ? $request->description : '',
			'require_non_expired' => isset( $request->require_non_expired ) ? $request->require_non_expired : 0,
			'external_reference'  => isset( $request->external_reference ) ? $request->external_reference : '',
			'status'              => isset( $request->status ) ? $request->status : 'active',
		];

		return ResponseService::respond( ResponseService::createProduct( $options ) );
	}

	public function updateProduct( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'product_id'          => isset( $request->product_id ) ? $request->product_id : 0,
			'source'              => isset( $request->source ) ? $request->source : 'internal',
			'name'                => isset( $request->name ) ? $request->name : '',
			'description'         => isset( $request->description ) ? $request->description : '',
			'require_non_expired' => isset( $request->require_non_expired ) ? $request->require_non_expired : 0,
			'external_reference'  => isset( $request->external_reference ) ? $request->external_reference : '',
			'status'              => isset( $request->status ) ? $request->status : 'active',
		];

		return ResponseService::respond( ResponseService::updateProduct( $options ) );
	}

	public function deleteProduct( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::deleteProduct( $request->product_id ) );
	}

	public function createLicenseKeyMeta( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::createLicenseKeyMeta( $request->license_key, $request->identifier, $request->key, $request->value ) );
	}

	public function updateLicenseKeyMeta( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::updateLicenseKeyMeta( $request->license_key, $request->identifier, $request->key, $request->value ) );
	}

	public function deleteLicenseKeyMeta( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::deleteLicenseKeyMeta( $request->license_key, $request->identifier, $request->key ) );
	}

	public function createProductMeta( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::createProductMeta( $request->product_id, $request->key, $request->value ) );
	}

	public function updateProductMeta( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::updateProductMeta( $request->product_id, $request->key, $request->value ) );
	}

	public function deleteProductMeta( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::deleteProductMeta( $request->product_id, $request->key ) );
	}

	public function getProducts( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::getProducts() );
	}

	public function getGenerators( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::getGenerators() );
	}

	public function generate( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::generate( $request->generator_id, $request->quantity ) );
	}

	public function getLicenseKeys( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'product_id'     => isset( $request->product_id ) ? $request->product_id : 0,
			'status'         => isset( $request->status ) ? $request->status : '',
			'owner_email'    => isset( $request->owner_email ) ? $request->owner_email : '',
			'owner_name'     => isset( $request->owner_name ) ? $request->owner_name : '',
			'page'           => isset( $request->page ) ? $request->page : 1,
			'items_per_page' => isset( $request->items_per_page ) && $request->items_per_page > 0 ? $request->items_per_page : 1,
		];

		return ResponseService::respond( ResponseService::getLicenseKeys( $options ) );
	}

	public function sendTelemetryData( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'product_id'                => isset( $request->product_id ) ? $request->product_id : 0,
			'user_identifier'           => isset( $request->user_identifier ) ? $request->user_identifier : '',
			'license_key'               => isset( $request->license_key ) ? $request->license_key : '',
			'activation_identifier'     => isset( $request->activation_identifier ) ? $request->activation_identifier : '',
			'product_version'           => isset( $request->product_version ) ? $request->product_version : '',
			'data_type'                 => isset( $request->data_type ) ? $request->data_type : '',
			'data_group'                => isset( $request->data_group ) ? $request->data_group : '',
			'numeric_data_single_value' => isset( $request->numeric_data_single_value ) ? (int) $request->numeric_data_single_value : 0,
			'numeric_data_x'            => isset( $request->numeric_data_x ) ? (int) $request->numeric_data_x : 0,
			'numeric_data_y'            => isset( $request->numeric_data_y ) ? (int) $request->numeric_data_y : 0,
			'text_data'                 => isset( $request->text_data ) ? $request->text_data : '',
		];

		return ResponseService::respond( ResponseService::sendTelemetryData( $options ) );
	}

	public function getTelemetryData( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'product_id'            => isset( $request->product_id ) ? $request->product_id : 0,
			'user_identifier'       => isset( $request->user_identifier ) ? $request->user_identifier : '',
			'license_key'           => isset( $request->license_key ) ? $request->license_key : '',
			'activation_identifier' => isset( $request->activation_identifier ) ? $request->activation_identifier : '',
			'product_version'       => isset( $request->product_version ) ? $request->product_version : '',
			'data_type'             => isset( $request->data_type ) ? $request->data_type : '',
			'data_group'            => isset( $request->data_group ) ? $request->data_group : '',
		];

		return ResponseService::respond( ResponseService::getTelemetryData( $options ) );
	}

	public function getAvailableLicenseKeysCount( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::getAvailableLicenseKeysCount( $request->product_id ) );
	}

	public function createContract( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'contract_key'          => isset( $request->contract_key ) ? $request->contract_key : '',
			'contract_name'         => isset( $request->contract_name ) ? $request->contract_name : '',
			'contract_information'  => isset( $request->contract_information ) ? $request->contract_information : '',
			'product_id'            => isset( $request->product_id ) ? $request->product_id : 0,
			'license_keys_quantity' => isset( $request->license_keys_quantity ) ? $request->license_keys_quantity : 1,
			'status'                => isset( $request->status ) ? $request->status : '',
			'can_get_info'          => isset( $request->can_get_info ) ? $request->can_get_info : 0,
			'can_generate'          => isset( $request->can_generate ) ? $request->can_generate : 0,
			'can_destroy'           => isset( $request->can_destroy ) ? $request->can_destroy : 0,
			'can_destroy_all'       => isset( $request->can_destroy_all ) ? $request->can_destroy_all : 0,
		];

		return ResponseService::respond( ResponseService::createContract( $options ) );
	}

	public function updateContract( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		$options = [
			'contract_id'           => isset( $request->contract_id ) ? $request->contract_id : 0,
			'contract_key'          => isset( $request->contract_key ) ? $request->contract_key : '',
			'contract_name'         => isset( $request->contract_name ) ? $request->contract_name : '',
			'contract_information'  => isset( $request->contract_information ) ? $request->contract_information : '',
			'product_id'            => isset( $request->product_id ) ? $request->product_id : 0,
			'license_keys_quantity' => isset( $request->license_keys_quantity ) ? $request->license_keys_quantity : 1,
			'status'                => isset( $request->status ) ? $request->status : '',
			'can_get_info'          => isset( $request->can_get_info ) ? $request->can_get_info : 0,
			'can_generate'          => isset( $request->can_generate ) ? $request->can_generate : 0,
			'can_destroy'           => isset( $request->can_destroy ) ? $request->can_destroy : 0,
			'can_destroy_all'       => isset( $request->can_destroy_all ) ? $request->can_destroy_all : 0,
		];

		return ResponseService::respond( ResponseService::updateContract( $options ) );
	}

	public function deleteContract( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::deleteContract( isset( $request->contract_id ) ? $request->contract_id : 0 ) );
	}

	public function getContracts( Request $request ) {
		Log::add( '200', $request->api_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ResponseService::respond( ResponseService::getContracts() );
	}
}
