<?php

namespace App\Http\Controllers\Api\Contracts\V1;

use App\Http\Controllers\Controller;
use App\Services\Api\Contracts\V1\ContractResponseService;
use App\Services\Log;
use Illuminate\Http\Request;

class ContractApiController extends Controller {


	public function getInfo( Request $request ) {
		Log::add( '208', $request->contract_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ContractResponseService::respond( ContractResponseService::getInfo( $request->contract_key ) );
	}

	public function generate( Request $request ) {
		Log::add( '208', $request->contract_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ContractResponseService::respond( ContractResponseService::generate( $request->contract_key, (int) $request->quantity ) );
	}

	public function destroy( Request $request ) {
		Log::add( '208', $request->contract_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ContractResponseService::respond( ContractResponseService::destroy( $request->contract_key, $request->license_key ) );
	}

	public function destroyAll( Request $request ) {
		Log::add( '208', $request->contract_key, request()->ip(), array_merge( [ 'endpoint' => $request->route()->getName() ], $request->all() ) );

		return ContractResponseService::respond( ContractResponseService::destroyAll( $request->contract_key ) );
	}
}
